	function PLOT_PHASE_ERROR_Z(wT, Phase_error, minPhase, maxPhase)
 
	% Plots the phase error for an IIR filter.
 
	%	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% Author: 			Lars Wanhammar 2005-05-07
	% Modified by: 	 
	% Copyright:		by authors - not released for commercial use
	% Version:			1 
	% Known bugs:	 
	% Report bugs to:	Wanhammar@gmail.com
	
	%========================================================	
	% Standard settings
	fs = 16; 		% Font size
	lw = 2; 		% Linewidth
	fn = 'times'; 	% Font
	%========================================================	
	hold on;
	
	plot(wT, Phase_error,'linewidth', lw);	
	axis([0 max(wT) minPhase maxPhase]);	
	 
%	xlabel('{\it\omegaT}  [rad]','FontName', fn,'FontSize', fs);
	set(gca,'FontName', fn,'FontSize', fs);
		
	ax = [0 0.03*pi 0.06*pi 0.09*pi 0.12*pi];
	lab = {'0';'0.03\pi';'0.06\pi';'0.09\pi';'0.12\pi'};
	xtick(ax,lab);
	ylabel('{\it\Delta\it\Phi}({\ite^j^\omega^T}) [rad]','FontName','times','FontSize',16);
	grid on
	box on
